﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint;

namespace IterateDocuments
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            using (SPWeb web = site.OpenWeb())
            {
               SPList listDocuments = 
                  web.Lists.TryGetList("Dokumente");
               SPDocumentLibrary docLib = 
                  listDocuments as SPDocumentLibrary;

               TraverseFolder(docLib.RootFolder, 0);
            }
         }     
      }

      public static void TraverseFolder(SPFolder folder, int level)
      {
         Console.WriteLine("{0}{1} ({2})",
            String.Empty.PadLeft(level),
            folder.Name,
            folder.Files.Count);

         // Hole die Collection sämtlicher Dateien
         SPFileCollection allFilesInFolder = folder.Files;

         // Iteriere die Dateien
         foreach (SPFile file in allFilesInFolder)
         {
            Console.WriteLine("{0}{1} ({2})", 
               String.Empty.PadLeft(level+2),
               file.Name,     // Dateiname
               file.Length);  // Dateigröße            
         }

         Console.WriteLine();

         // Hole die Liste der Unterordner
         SPFolderCollection subfolders = folder.SubFolders;

         // Wenn Unterordner vorhanden, Methode erneut ausführen
         if (subfolders.Count > 0)
         {
            level++;
            foreach (SPFolder subfolder in folder.SubFolders)
            {               
               TraverseFolder(subfolder, level);
            }
         }
      }
   }
}
